#!/bin/sh


#SNMP OIDs we'll care about:
dateTimeNowOID="HOST-RESOURCES-MIB::hrSystemDate.0"
interfaceTableOID="IF-MIB::ifDescr"
interfaceInBytesOID="IF-MIB::ifInOctets"
interfaceOutBytesOID="IF-MIB::ifOutOctets"

snmpget=`which snmpget`
snmpwalk=`which snmpwalk`

status=""

usage() {
	echo " Usage: $0 -i interface  -l limit"
	echo "$0 -h (shows this message)"
	echo "Replace <interface> with the interface you want to monitor"
	echo "Replace <limit> with your monthly badwidth allotment measured in bytes"
}


nagiosExit() {
	echo $2
	case $1 in
	OK)		exit 0;;
	WARNING)	exit 1;;
	CRITICAL)	exit 2;;
	UNKNOWN)	exit 3;;
	*)		exit 255;;
	esac
}

if [ "$#" -lt 1 ]; then
	nagiosExit UNKNOWN "You must supply some parameters"
fi


# GET ARGS
while getopts H:i:l:h o
do	case "$o" in
	H)	host="$OPTARG";;
	i)	interface="$OPTARG";;
	l)	limit="$OPTARG";;
	h)	usage
		nagiosExit UNKNOWN " ";;
	esac
done
shift $OPTIND-1


# Grab the list of interfaces from the host and figure out
# the index of the array we're interested in

walk="$snmpwalk -v2c -c public $host $interfaceTableOID"
echo $walk

i=0
$walk | while read line
do
	interfaceList[ $i ]="$line"
	(( i++ ))
done

echo ${interfaceList[@]}

nagiosExit "OK" "Wowsers, I have don't anything"
