#!/bin/sh


#SNMP OIDs we'll care about:
dateTimeNowOID="HOST-RESOURCES-MIB::hrSystemDate.0"
interfaceTableOID="IF-MIB::ifDescr"
interfaceInBytesOID="IF-MIB::ifInOctets"
interfaceOutBytesOID="IF-MIB::ifOutOctets"

status=""


nagiosExit() {
	echo $2
	case $1 in
	OK)		exit 0;;
	WARNING)	exit 1;;
	CRITICAL)	exit 2;;
	UNKNOWN)	exit 3;;
	*)		exit 255;;
	esac
}

if [ "$#" -lt 1 ]; then
	nagiosExit UNKNOWN "You must supply some parameters"
fi


# GET ARGS
while getopts r:i:w:h o
do	case "$o" in
	r)	resetdate="$OPTARG";;
	i)	interface="$OPTARG";;
	w)	warning="$OPTARG";;
	h)	print >&2 " Usage: $0 -r date -i interface  [-w warning threshold]" \
		"\n\t$0 -h (shows this message)" \
		"\n\n\tdate should be the time you want the counters to reset" \
		"\n\tit will use the format <m|d>[dd]HHMM" \
		"\n\tso if you want to reset at the start of the month use m010000" \
		"\n\tor if you want to reset daily at 3:00 AM use d0300" \
		"\n\twarning threshold is optional and measured in bytes."
		exit 1;;
	esac
done
shift $OPTIND-1

period="$(echo "$resetdate" | cut -c1)"
case "$period" in
	m | M )	monthlogic;;
	d | D ) daylogic;;
	* ) 	status="You didn't specify a valid date"
		nagiosExit UNKNOWN "$status";;
esac


nagiosExit "OK" "Wowsers, I have don't anything"
