#!/usr/bin/python

#################################################################################
#
# NAME: 	check_snmp_usage.py
#
# COMMENT:  Nagios check to monitor Internet connections that have monthly 
#           usage caps. Requires the creation of a state file. No warning or
#           critical thresholds necessary, will go WARNING if you are headed
#           towards over usage based upon current usage and current date. Will
#           go CRITICAL when you've actually surpassed your allotment. Will use
#           command line SNMP so no extra Python libraries are required.
#
# TODO:     - Everything
#           - As an added feature I'll someday make it work on daily caps and
#           additionally make it so you can adjust the day of the month to reset
#           - Add in the ability to use perfdata as a simple bandwidth
#           method to create graphs in Nagios
#           - SNMP v3?
#
#
# Release Hitory:
#
#################################################################################


import os
import sys
import getopt
import re
import subprocess

host = ''
communityString = 'public'
OIDDateTime = '.1.3.6.1.2.1.25.1.2.0'
OIDIfDescr = '.1.3.6.1.2.1.2.2.1.2'
OIDIfInBytes = '.1.3.6.1.2.1.2.2.1.10.1.'
OIDIfOutBytes = '.1.3.6.1.2.1.2.2.1.16.1.'

#USAGE
def usage():
        print('Usage: check_snmp_usage.py -H hostname -i interface -b bandwidth limit (bytes) -c community string \n')
try:
        opts, args = getopt.getopt(sys.argv[1:], 'H:i:b:c')
except getopt.GetoptError as err:
        print(err)
        usage()
        sys.exit(3)

for opt, arg in opts:
        if opt in ('-H'):
                host = arg
        elif opt in ('-i'):
                interface = arg
        elif opt in ('-b'):
                bytesLimit = arg
        elif opt in ('-c'):
                communityString = arg
        else:
                usage()
                sys.exit(3)

if not 'host' in locals():
        print('No host specified')
        sys.exit(3)

# Find snmpwalk and snmpget

sp = subprocess.Popen(['which', 'snmpget'], stdout=subprocess.PIPE, stderr=subprocess.PIPE)
stdout, stderr = sp.communicate()
if sp.returncode == 0:
	snmpget = stdout.rstrip()
else:
	print('I couldn\'t find snmpget on your system, unable to finish')
	sys.exit(3)

sp = subprocess.Popen(['which', 'snmpwalk'], stdout=subprocess.PIPE, stderr=subprocess.PIPE)
stdout, stderr = sp.communicate()
if sp.returncode == 0:
	snmpwalk = stdout.rstrip()
else:
	print('I couldn\'t find snmpwalk on your system, unable to finish')
	sys.exit(3)



# Start by getting the list of available interfaces

walkIfsCmd = [snmpwalk, '-v2c', '-c', communityString, host, OIDIfDescr]
sp = subprocess.Popen(walkIfsCmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
stdout, stderr = sp.communicate()
walkOut = stdout.rstrip().split('\n')
for line in walkOut:
	if line.split()[-1] == interface:
		index = line.split()[0].split('.')[-1]

if not 'index' in locals():
	print('No matching interfaces found!')
	sys.exit(3)

# Now let's grab our counters and the date of the remote system

getDateTimeCmd = [snmpget, '-v2c', '-c', communityString, host, OIDDateTime]
sp = subprocess.Popen(getDateTimeCmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
stdout, stderr = sp.communicate()
dateTime = stdout.rstrip().split()[-1]
date = dateTime.split(',')[0]
time = dateTime.split(',')[1]
year = date.split('-')[0]
month = date.split('-')[1]
day = date.split('-')[2]
hour = time.split(':')[0]
minute = time.split(':')[1]
second = time.split(':')[2]

getInBytesCmd = [snmpget, '-v2c', '-c', communityString, host, OIDIfInBytes + index]
getOutBytesCmd = [snmpget, '-v2c', '-c', communityString, host, OIDIfOutBytes + index]

sp = subprocess.Popen(getInBytesCmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
stdout, stderr = sp.communicate()
inBytes = stdout.rstrip().split()[-1]

sp = subprocess.Popen(getOutBytesCmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
stdout, stderr = sp.communicate()
outBytes = stdout.rstrip().split()[-1]

# Time to see if we have a temp file in place or not and read it if we do
