#!/bin/sh

status=""

exitunknown() {
	echo "UNKNOWN - $status"
	exit 3
}


monthlogic() {

}
# GET ARGS
while getopts r:i:w: o
do	case "$o" in
	r)	resetdate="$OPTARG";;
	i)	interface="$OPTARG";;
	w)	warning="$OPTARG";;
	[?])	print >&2 " Usage: $0 -r date -i interface  [-w warning threshold]" \
		"\n\n\tdate should be the time you want the counters to reset" \
		"\n\tit will use the format <m|d>[DD]HHMM" \
		"\n\tso if you want to reset at the start of the month use m010000" \
		"\n\tor if you want to reset daily at 3:00 AM use d0300" \
		"\n\twarning threshold is optional and measured in bytes."
		exit 1;;
	esac
done
shift $OPTIND-1

period="$(echo "$resetdate" | cut -c1)"
case "$period" in
	m | M )	monthlogic;;
	d | D ) periodsecs=86400;;
	* ) 	status="You didn't specify a valid date"
		exitunknown;;
esac

ifconfig $interface >/dev/null 2>&1
rc=$?
if [ $rc -ne 0 ]; then
	status="The interface $interface isn't valid on this system."
	exitunknown
fi

echo $resetdate
echo $warning
