check_snapshot.py

DESCRIPTION:
Python script to grab ages of all snapshots plainly visible on an ESX hosts mounted datastores. Written with Nagios in mind so exit codes correspond to Nagios service states as well as stdout describing the outcome of the check.

REQUIRES:
Python. My test and production environment are 2.6.6 (CentOS 6.4 base repo) as of this writing.

SSH access to BusyBox console on ESX server. Tested on ESXi 5.1. Requires the following command line utilities in the BusyBox console:
	find (used for locating the snapshots)
	grep (used for finding the pretty name of the VMs)
	stat (used for finding the age of the snapshot vmsn file)

This also means you'll need a local user account on the ESX host with SSH access and and unfortunately my research leads me to believe that you can't really use RBAC to tighten up the permissions for that user. It seems in order to have BusyBox access the user needs to be assigned the administrator role.

Paramiko python library is required for making ssh connection to server. I try to avoid relying on Windows/Powershell for my monitoring environments. The vSphere Command-Line Interface has no (obvious) utilities for finding snapshot information.

A note on Paramiko: In order to get paramiko to import on my CentOS 6.4 system without error I had to comment out line 56-57 in /usr/lib64/python2.6/site-packages/Crypto/Util/number.py - Problem identified and resolved here: https://github.com/ansible/ansible/issues/276

USAGE:
check_snapshot.py -H hostname [-U username] <-p password|-f filename> [-w warning] [-c critical]

hostname is required, this is the ESX host you wish to run the command against
username is not required, if not specified the script defaults to root
password or filename specifies the password used to log on to the ESX host. If using a file (preferred for security reasons), specify a file with only 1 line containing the password of the username you wish to use.
warning and critical are used when the check is run to return data to Nagios. If they're not specified the check will just send informational output back to stdout.

LICENSE:
Copyright (c) 2013, JR Dalrymple
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
