#!/usr/bin/python

import os
import sys
import getopt
import re

dscli = '/opt/ibm/dscli/dscli'
lssi = 'lssi'
lsddm = 'lsddm '
lssiout = []
lsddmout = []
faileddiskcount = 0
faileddisklist = []

#USAGE
def usage():
        print('Usage: check_ds8k_disk.py -P /path/to/profile.cfg -u userid -p password \n')
        print('[ -w warning ] [-c critical ]\n\n')
        print('Profile, userid and password must be specified.\n')
        print('Be sure to protect your nagios configurations appropriately!\n')
try:
        opts, args = getopt.getopt(sys.argv[1:], 'P:u:p:w:c:')
except getopt.GetoptError as err:
        print(err)
        usage()
        sys.exit(3)

for opt, arg in opts:
        if opt in ('-P'):
                dsProfile = arg
        elif opt in ('-u'):
                userid = arg
        elif opt in ('-p'):
                password = arg
        elif opt in ('-c'):
                critical = int(arg)
        elif opt in ('-w'):
                warning = int(arg)
        else:
                usage()
                sys.exit(3)

if not os.path.isfile(dscli):
        print('Could not find dscli executable.')
        sys.exit(3)

if not 'dsProfile' in locals():
        print('No profile specified.')
        sys.exit(3)
elif not os.path.isfile(dsProfile):
        print('Could not find specified profile.')
        sys.exit(3)

if not 'userid' in locals():
        print('No userid specified.')
        sys.exit(3)
if not 'password' in locals():
        print('No password specified.')

# useful dscli argument string
dscliargs = ' -cfg ' + dsProfile + ' -user ' + userid + ' -passwd ' + password + ' '

io = os.popen(dscli + dscliargs + lssi, 'r')
while 1:
        line = io.readline()
        if not line:
                break
        lssiout.append(line.rstrip())

arrayid = str(lssiout[-1]).split()[1].rstrip()

if not arrayid and not 'arrayid' in locals():
        print('Could not determine array ID.')
        sys.exit(3)
else:
        lsddm = lsddm + arrayid

io = os.popen(dscli + dscliargs + lsddm, 'r')
while 1:
        line = io.readline()
        if not line:
                break
        lsddmout.append(line.rstrip())

if not lsddmout:
        print('Could not retrieve disk data with the lsddm command.')
        sys.exit(3)
else:
        for line in lsddmout:
                if re.search('Failed', line):
                        faileddiskcount += 1
                        faileddisklist.append(line.split()[0])

if 'critical' in locals():
        if faileddiskcount > critical:
                print('Failed disk count at critical level!')
                for disk in faileddisklist:
                        print('Disk ' + disk.rstrip() + ' failed.')
                sys.exit(2)
if 'warning' in locals():
        if faileddiskcount > warning:
                print('Failed disk count at warning level!')
                for disk in faileddisklist:
                        print('Disk ' + disk.rstrip() + ' failed.')
                sys.exit(1)
if not 'critical' in locals() and not 'warning' in locals():
        if faileddiskcount > 0:
                print('Failed disk count at critical level!')
                for disk in faileddisklist:
                        print('Disk ' + disk.rstrip() + ' failed.')
                sys.exit(2)
else:
        print('Failed disk count at acceptable level.')
        for disk in faileddisklist:
                print('Disk ' + disk.rstrip() + ' failed.')
        sys.exit(0)