#!/usr/bin/python
import sys
import os
import re

# Strings we have to match
# Match something like "define host {" and explode it so we can grab the "host" bit
startObjMatch = re.compile(r"(^\s*define\s*)(\S*)(.*{\s*$)")
# Match something like "     }"
endObjMatch = re.compile(r"^\s*}\s*$")

# Open the objects.cache file
with open('objects.cache') as f:
        statusdat = f.read().splitlines()
f.close()


#Loop through the file
for line in statusdat:
	if startObjMatch.match(line):
		print line
		objType = startObjMatch.search(line).group(2)
	if endObjMatch.match(line):
		print line
