#!/usr/bin/python
import sys
import os
import re

# Definitions
objType = None
objDef = []
objects = []

# Strings we have to match
# Match something like "define host {" and explode it so we can grab the "host" bit
startObjMatch = re.compile(r"(^\s*define\s*)(\S*)(.*{\s*$)")
# Match something like "     }"
endObjMatch = re.compile(r"^\s*}\s*$")
# Match all of the directives between
midObjMatch = re.compile(r"^\s*(\S*)\s*(.*)\s*")

# Open the objects.cache file
with open('objects.cache') as f:
        statusdat = f.read().splitlines()
f.close()


#Loop through the file
for line in statusdat:
	if startObjMatch.match(line):
		objType = startObjMatch.search(line).group(2)
		objDef.append(objType)
		continue
	if endObjMatch.match(line):
		objects.append(objDef)
		objType = None
		objDef = []
		continue
	if objType:
		objDef.append(midObjMatch.search(line).group(1))
		objDef.append(midObjMatch.search(line).group(2))

for object in objects:
	for directive in object:
		print directive
