#!/usr/bin/python

#################################################################################
#
# NAME: 	check_passive_autocreate.py
#
# COMMENT:  Python program that will compare nagios.log unconfigured services
#           with objects.cache file configured objects. If the host matches it
#           will create the new service using a template FILE you specify.
#           Requires that the nagios user has sudo access to restart nagios.
#           Also this iteration assumes systemd, for older Linux you'll have to
#           adjust.
#
# TODO:     - Make it so that the template file can have register 0 and the new
#           services still get registerd.
#           - Add init system support.
#
#
# Release Hitory:
#
# 0.1 - 10/28/2015 - Initial Release. It totally works.
#################################################################################


import os
import sys
import getopt
import re

nagiosLog = '/usr/local/nagios/var/nagios.log'
nagiosObjectsFile = '/usr/local/nagios/var/objects.cache'
cfgInFile = ''
cfgOutDir = ''
host = ''
servicesToCreate = []
servicesToPop = []
hostServiceList = []
existingServices = []
outLines = []

service_descriptionMatch = re.compile(r"^\s*service_description.*")
unconfiguredServiceMatch = re.compile(r"(^.*Passive check result was received for service ')(.*?)(' on host ')(.*?)(', but the service could not be found)")

# Borrowing some code from my other project (should turn it into a module I suppose)

startObjMatch = re.compile(r"(^\s*define\s*)(\S*)(.*{\s*$)")
endObjMatch = re.compile(r"^\s*}\s*$")
midObjMatch = re.compile(r"^\s*(\S*)\s*(.*)\s*")


#USAGE
def usage():
        print('Usage: check_passive_autocreate.py -H hostname -i /path/to/template.cfg -d /path/to/passive/service.cfg \n')
try:
        opts, args = getopt.getopt(sys.argv[1:], 'H:i:d:')
except getopt.GetoptError as err:
        print(err)
        usage()
        sys.exit(3)

for opt, arg in opts:
        if opt in ('-H'):
                host = arg
        elif opt in ('-i'):
                cfgInFile = arg
        elif opt in ('-d'):
                cfgOutDir = arg
        else:
                usage()
                sys.exit(3)

if not 'cfgInFile' in locals():
        print('No input template specified.')
        sys.exit(3)
if not os.path.isfile(cfgInFile):
        print('Could not find input template.')
        sys.exit(3)

if not 'host' in locals():
        print('No host specified - we don\'t want to create a service for any random host sending passive checks do we?')
        sys.exit(3)

if not 'cfgOutDir' in locals():
        print('No output directory specified.')
        sys.exit(3)
if not os.path.isdir(cfgOutDir):
        print('Could not find output directory, check and make sure it exists.')
        sys.exit(3)

with open(nagiosObjectsFile) as f:
	nagiosObjectsLines = f.read().splitlines()
f.close

interested = 0
newService = ['','']
for line in nagiosObjectsLines:
	if startObjMatch.match(line):
		if startObjMatch.search(line).group(2) == "service":
			interested = 1
			continue
	if midObjMatch.search(line).group(1) == 'host_name' and interested == 1:
		newService[0] = midObjMatch.search(line).group(2)
		continue
	if midObjMatch.search(line).group(1) == 'service_description' and interested == 1:
		newService[1] = midObjMatch.search(line).group(2)
		continue
	if endObjMatch.match(line) and interested == 1:
		existingServices.append(newService)
		newService = ['','']
		interested = 0

for existingService in existingServices:
	if existingService[0] != host:
		servicesToPop.append(existingService)

for service in servicesToPop:
	existingServices.remove(service)

for remaining in existingServices:
	hostServiceList.append(remaining[1])

with open(nagiosLog) as f:
	nagiosLogLines = f.read().splitlines()
f.close

for line in nagiosLogLines:
	if unconfiguredServiceMatch.match(line):
		if unconfiguredServiceMatch.search(line).group(4) == host:
			servicesToCreate.append(unconfiguredServiceMatch.search(line).group(2))

servicesToCreate = list(set(servicesToCreate))
for servicesNotToCreate in hostServiceList:
	if servicesNotToCreate in servicesToCreate:
		servicesToCreate.remove(servicesNotToCreate)

### Here we are finally with the list of services we need to create for the host - list servicesToCreate


with open(cfgInFile) as f:
	cfgTemplateLines = f.read().splitlines()
f.close

for newService in servicesToCreate:
	for line in cfgTemplateLines:
		if service_descriptionMatch.match(line):
			outLines.append("\tservice_description\t\t\t" + newService + "\n")
		else:
			outLines.append(line + "\n")
	newFilename = cfgOutDir + newService + ".cfg"
	f = open(newFilename, 'w')
	for line in outLines:
		f.write(line)
	f.close
	outLines = []

if len(servicesToCreate) > 0:
	os.system("/usr/bin/sudo /usr/bin/systemctl restart nagios")
