﻿#################################################################################
#
# NAME: 	check_citrix_user.ps1
#
# COMMENT:  Script to send NSCA passive check for each user logged into a Citrix
#           XenApp 6.x environment. Useful for doing reporting on which users are
#           Logging in when
#
#
# Release Hitory:
#
# 10/28/2015 - Initial Release. It works. Could use a usage or something.
#################################################################################

$nscpBinary = "c:\program files\NSClient++\nscp.exe"
$returnCode = "3" #Unknown by default 
$nagiosHost = "mn-lx9.gsellc.local" # this is the host running the NSCA daemon
$encryption = "3des" # set this to match nsca.cfg on the Nagios host
$payloadLength = "4096" # set this to match your nsca daemon, the default is 512
$nscaPassword = "somepassword" # set this to match nsca.cfg on the Nagios host
$sourceHost = "CitrixFarm" # This needs to match the host you have configured in Nagios for these passive checks
$userStringArray = @()


function nagiosExit($returnCode, $statusOutput) {
    Write-Host $statusOutput
    Exit $returnCode
}

function sendNscaExit($returnCode, $statusoutput) {
}

if ( (Get-PSSnapin -Name Citrix.XenApp.Commands -ErrorAction SilentlyContinue) -eq $null ) {
    Add-PSSnapin -Name Citrix.XenApp.Commands -ErrorAction SilentlyContinue
    if ( (Get-PSSnapin -Name Citrix.XenApp.Commands -ErrorAction SilentlyContinue) -eq $null) {
        nagiosExit "2" "Unable to load necessary Citrix PowerShell Snapins"    
    }
}

$loggedOnUsers = Get-XASession -full  | where-object { ($_.ApplicationState -eq 'Active') } | select AccountName

function sendNscaExit($returnCode, $statusoutput) {
}

foreach ($user in $loggedOnUsers) {
    $userString = $user.AccountName
    $userStringArray += $userString -replace '^.*\\',''
}
$userStringArray = $userStringArray | Select -Unique

foreach ($user in $userStringArray) {
    $nscpArgs = @("nsca",
                  "host=$nagiosHost",
                  "command=$user",
                  "message=user $user is currently online",
                  "result=0",
                  "encryption=$encryption",
                  "payload-length=$payloadLength",
                  "password=$nscaPassword",
                  "source-host=$sourceHost")
    &$nscpBinary $nscpArgs

}
