#!/usr/bin/python

#

import sys
import os
import getopt
import re
from datetime import datetime
import netsnmp
import pickle

hostname = 0
warning = 0
critical = 0
warnList = []
critList = []
version = '1'
community = 0
oidIndex = '.1.3.6.1.4.1.1588.2.1.1.1.6.2.1.1'
oidName = '.1.3.6.1.4.1.1588.2.1.1.1.6.2.1.36'
oidC3discards = '.1.3.6.1.4.1.1588.2.1.1.1.6.2.1.28'
oidB2BNoCredits = '.1.3.6.1.4.1.1588.2.1.1.1.6.2.1.20'
debug = 0
portdict = {}
olddict = {}
tmpfile = ''
exitStatus = ""
timedelta = ""


# USAGE
def usage():
    print "usage: check_brocade.py -H hostname"

# Get Command Line Arguments
try:
    opts, args = getopt.getopt(sys.argv[1:], "H:V:C:c:w:", ["hostname=", "version=", "community="])
except getopt.GetoptError as err:
    print err
    usage()
    sys.exit(3)

for opt, arg in opts:
    if opt in ('-H', '--hostname'):
        hostname = arg
    elif opt in ('-V', '--version'):
        version = arg
    elif opt in ('-C', '--community'):
        community = arg
    elif opt in ('-w'):
        warning = int(arg)
    elif opt in ('-c'):
        critical = int(arg)
    else:
        usage()
        sys.exit(3)

# Command Line Argument tests
if not hostname:
    print "No hostname specified"
    usage()
    sys.exit(3)

tmpfile = '/tmp/check_brocade_port_err_' + hostname + '_.pkl'

class fcport:
	def __init__(self, index):
		self.index = str(index)
		self.name = 0 
	def getC3discards(self):
		var = netsnmp.Varbind(oidC3discards + '.' + self.index)
		self.C3discards = netsnmp.snmpget(var, Version=int(version), DestHost=hostname, Community=community)[0]

	def getB2BNoCredits(self):
		var = netsnmp.Varbind(oidB2BNoCredits + '.' + self.index)
		self.B2BNoCredits = netsnmp.snmpget(var, Version=int(version), DestHost=hostname, Community=community)[0]

	def getName(self):
		var = netsnmp.Varbind(oidName + '.' + self.index)
		self.name = netsnmp.snmpget(var, Version=int(version), DestHost=hostname, Community=community)[0]


# Load old dictionary from pickle file

if os.path.isfile(tmpfile):
	with open (tmpfile, 'rb') as input:
		olddict = pickle.load(input)
		if 'timestamp' in olddict.keys():
			timedelta = datetime.now() - olddict['timestamp']
else:
	olddict = {}

var = netsnmp.Varbind(oidIndex)
session = netsnmp.snmpwalk(var, Version=int(version), DestHost=hostname, Community=community)
for obj in session:
	portdict[obj] = fcport(obj)

for v in portdict.itervalues():
	v.getC3discards()
	v.getB2BNoCredits()


# No processing if the port has no errors:

	if int(v.C3discards) + int(v.B2BNoCredits):


# Error identification

		v.getName()
		if not v.index in olddict.keys():
			exitStatus = exitStatus + v.name + " is is no longer error-free\n"
			olddict[v.index] = fcport(v.index)
			olddict[v.index].C3discards = 0
			olddict[v.index].B2BNoCredits = 0

		v.c3diff = int(v.C3discards) - int(olddict[v.index].C3discards)
		v.b2bdiff = int(v.B2BNoCredits) - int(olddict[v.index].B2BNoCredits)
		
		if (v.c3diff > warning) or (v.b2bdiff > warning):
			if (v.c3diff > critical) or (v.b2bdiff > critical):
				critList.append(v)
			else:
				warnList.append(v)
			
# Save objects to temp file


portdict['timestamp'] = datetime.now()

with open (tmpfile, 'wb') as pickleout:
	pickle.dump(portdict, pickleout, pickle.HIGHEST_PROTOCOL)


# Nagios exit logic

if len(critList) > 0:
    exitCode = 2
elif len(warnList) > 0:
    exitCode = 1
else:
    exitCode = 0

exitStatus = ""
if timedelta:
	exitStatus = exitStatus + "The time difference between checks is " + str(timedelta.seconds) + " seconds.\n"
else:
	exitStatus = exitStatus + "This is the first iteration of the port check.\n"
if warnList or critList:
    if warnList:
	for p in warnList:
		if p.c3diff:
			exitStatus = exitStatus + p.name + " had " + str(p.c3diff) + " new Class 3 discards\n"
		if p.b2bdiff:
			exitStatus = exitStatus + p.name + " had " + str(p.b2bdiff) + " new B2B Credit Zero errors\n"
    if critList:
	for p in critList:
		if p.c3diff:
			exitStatus = exitStatus + p.name + " had " + str(p.c3diff) + " new Class 3 discards\n"
		if p.b2bdiff:
			exitStatus = exitStatus + p.name + " had " + str(p.b2bdiff) + " new B2B Credit Zero errors\n"

else:
	exitStatus = exitStatus + "no ports with enough new errors that it's worth mentioning."

print exitStatus
sys.exit(exitCode)
